<?php

namespace App\Models;

use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Transaksi extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'member_id',
        'kd_transaksi',
        'jumlah',
        'ongkir',
        'diskon',
        'total',
        'dibayar',
        'sts_transaksi',
        'via_bayar',
        'jns_transaksi',
        'sts_antar',
        'ip_address',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function member(): BelongsTo
    {
        return $this->belongsTo(Member::class);
    }

    public function keranjang(): HasOne
    {
        return $this->hasOne(Keranjang::class);
    }

    public function pembayaran(): HasOne
    {
        return $this->hasOne(Pembayaran::class);
    }

    public function kurir(): HasOne
    {
        return $this->hasOne(Kurir::class);
    }

    public function scopePencarian(Builder $query): void
    {
        $query->where('kd_transaksi', 'like', '%' . request('cari') . '%')
            ->orwhereHas('member', function ($query) {
                $query->where('nm_member', 'like', '%' .  request('cari') . '%');
            });
    }
}
